--********************************DISCLAIMER**************************************
--We do not support 32-bit versions of SQL Server due to memory constraints
--********************************************************************************

--********************************************************************************
--If you should have any comments, suggestions or improvements to these samples, 
--we welcome you to contact us at SampleCode@melissadata.com also please visit our 
--developers bulletin board at forum.melissadata.com.
--********************************************************************************

-- mdNameExample.sql
--
-- Melissa Data mdName API for SQL Server
-- Copyright 1993-2007 Melissa Data Corporation.
--
-- PRELIMINARY VERSION SUBJECT TO CHANGES

declare @FileLoc varchar(256), @License varchar(256)
declare @mdName int
declare @RetVal int

-- Change the following lines to reflect your installation location
--   of the mdName API and the license string:
-- The Data Files Directory must contain the following files: mdName.dat and mdName.cfg.
set @FileLoc = 'C:\program files\melissa data\dqt\data'

--********************** LICENSE STRINGS ***********************
--*     To unlock the full functionality of Name Object,       *
--*     	     Or to obtain a Demo License String        *
--* please call a sales representative at 1-800-MELISSA ext. 3 *
--*         (1-800-635-4772 x3) for a license string.          *
--**************************************************************

set @License = 'DEMO'

-- Create and initialize the API:
set @mdName = master.dbo.mdNameCreate()
set @RetVal = master.dbo.mdNameSetPathToNameFiles(@mdName, @FileLoc)
set @RetVal = master.dbo.mdNameSetLicenseString(@mdName, @License);

if @RetVal = 0 begin
	raiserror('Invalid License String.',1,2)
	raiserror('Please contact a Melissa Data sales representative at 1-800-800-6245 x3 for a valid license string.',1,2)
	return
end
if master.dbo.mdNameInitializeDataFiles(@mdName) != 0 begin
	declare @Error varchar(256)
	set @Error = master.dbo.mdNameGetInitializeErrorString(@mdName)
	raiserror('Error initializing mdName API: "%s"', 16, 1, @Error)
	return
end

-- Set a few processing options:
set @RetVal = master.dbo.mdNameSetPrimaryNameHint(@mdName, 2)             -- NameHints::VeryLikelyFull
set @RetVal = master.dbo.mdNameSetFirstNameSpellingCorrection(@mdName, 1)
set @RetVal = master.dbo.mdNameSetSalutationPrefix(@mdName, 'Dear')
set @RetVal = master.dbo.mdNameSetSalutationSuffix(@mdName, ':')
set @RetVal = master.dbo.mdNameSetSalutationSlug(@mdName, 'Valued Customer')

-- Split the Full Name, assign Genders and generate a Salutation:
use mdName
update mdName set
	Gender1 = master.dbo.mdNameParseGender(@mdName, FullName),
	Prefix1 = master.dbo.mdNameParsePrefix(@mdName, FullName),
	FirstName1 = master.dbo.mdNameParseFirstName(@mdName, FullName),
	MiddleName1 = master.dbo.mdNameParseMiddleName(@mdName, FullName),
	LastName1 = master.dbo.mdNameParseLastName(@mdName, FullName),
	Suffix1 = master.dbo.mdNameParseSuffix(@mdName, FullName),
	Gender2 = master.dbo.mdNameParseGender2(@mdName, FullName),
	Prefix2 = master.dbo.mdNameParsePrefix2(@mdName, FullName),
	FirstName2 = master.dbo.mdNameParseFirstName2(@mdName, FullName),
	MiddleName2 = master.dbo.mdNameParseMiddleName2(@mdName, FullName),
	LastName2 = master.dbo.mdNameParseLastName2(@mdName, FullName),
	Suffix2 = master.dbo.mdNameParseSuffix2(@mdName, FullName),
	Salutation = master.dbo.mdNameParseSalutation(@mdName, FullName),
	Results = master.dbo.mdNameGetResults(@mdName)
	
-- Free the API:
set @RetVal = master.dbo.mdNameDestroy(@mdName)
